package cn.com.duiba.cloud.openapi.service.base.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 对象属性
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/2/9 6:05 下午
 **/
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface OpenModelProperty {
    /**
     * 属性名
     *
     * @return
     */
    String name() default "";

    /**
     * 是否必填
     *
     * @return
     */
    boolean required() default false;

    /**
     * 示例
     *
     * @return
     */
    String example() default "";
}
