package cn.com.duiba.cloud.openapi.service.base.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 开放接口配置注解
 * 该接口加在方法上，需要配合{@link OpenApi}一起使用
 *
 *
 * 生效时机：项目启动时
 *
 * 关于接口上下线：
 * 1、需要通过开放平台修改状态进行上下线
 * 注意：服务下线不能直接删除@ApiPath注解，即使删除开放平台依然有相关接口记录，如果要下线需要告知开放平台进行下线。
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/20 10:58 上午
 **/
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface OpenPath {
    /**
     * 对外路径
     * eg: @OpenPath(apiPath="/test")
     *
     * @return
     */
    String apiPath();

    /**
     * 接口描述，128个字符以内
     * @return
     */
    String apiDesc();
}
