package cn.com.duiba.cloud.openapi.service.base.utils;

import cn.com.duiba.cloud.openapi.service.base.annotation.OpenApi;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenModel;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenModelProperty;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenPath;
import cn.hutool.core.lang.Assert;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

/**
 * openApi文档生成工具
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/19 3:34 下午
 **/
public class OpenApiDocUtil {
    /**
     * 输出api文档
     *
     * @param method eg:  Method method = RemoteOrderWriteService.class.getMethod("createOrder", OrderCreateParam.class);
     * @return
     */
    public static String createApiDoc(Method method) {
        StringBuilder apiDoc = new StringBuilder();
        try {
            OpenApi openApi = method.getDeclaringClass().getDeclaredAnnotation(OpenApi.class);
            OpenPath openPath = method.getDeclaredAnnotation(OpenPath.class);
            if (openApi != null && openPath != null) {
                apiDoc.append("# " + openPath.apiDesc() + "\n");
                apiDoc.append("\n");
                apiDoc.append("---\n");
                apiDoc.append("\n");
                apiDoc.append("## " + openApi.prefix() + openPath.apiPath() + "\n");
                apiDoc.append("\n");
                apiDoc.append("接口描述：" + openPath.apiDesc() + "\n");
            }
            apiDoc.append("> 免费 ｜ 必须用户授权 ｜ 版本1.0\n");
            apiDoc.append("\n");
            apiDoc.append("### 请求方式\n");
            apiDoc.append("\n");
            apiDoc.append("**POST**\n");
            apiDoc.append("\n");
            apiDoc.append("### 公共参数\n");
            apiDoc.append("\n");
            apiDoc.append("公共请求参数\n");
            apiDoc.append("\n");
            apiDoc.append("|  参数   | 类型  |  必须   | 描述   |\n");
            apiDoc.append("|  ----  | ----  |  ----  | ----  |\n");
            apiDoc.append("|  access_token | String | 是  | 授权码，OAuth授权得到得token，必填参数 <br>**示例值：d60ae854-cea2-45b7-84c8-db35e17ffc9c**|\n");
            apiDoc.append("\n");
            apiDoc.append("### 请求体参数\n");
            apiDoc.append("\n");
            Class<?> type = method.getParameters()[0].getType();
            Assert.isFalse(type.isPrimitive(), "参数类型不能为基本类型");

            OpenModel annotationParam = type.getAnnotation(OpenModel.class);
            if (annotationParam != null) {
                apiDoc.append(annotationParam.name() + ":" + annotationParam.description());
                apiDoc.append("\n");
            }

            Field[] paramFields = type.getDeclaredFields();
            createParam(apiDoc, paramFields);

            apiDoc.append("\n");
            apiDoc.append("### 响应参数\n");
            apiDoc.append("\n");
            Assert.isFalse(method.getReturnType().isPrimitive(), "参数类型不能为基本类型");

            OpenModel annotationReturn = method.getReturnType().getAnnotation(OpenModel.class);
            if (annotationReturn != null) {
                apiDoc.append(annotationReturn.name() + ":" + annotationReturn.description());
                apiDoc.append("\n");
            }
            Field[] returnTypeFields = method.getReturnType().getDeclaredFields();
            createParam(apiDoc, returnTypeFields);

            apiDoc.append("\n");
            apiDoc.append("### 请求示例\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("\n");
            apiDoc.append("{\n" +
                    "    \"sign\": \"445F5858242040FB3EB7CEA3975C2905\",\n" +
                    "    \"param\": {\n" +
                    "        //请求体参数\n" +
                    "    }\n" +
                    "}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("### 响应示例\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n" +
                    "    \"success\": true,\n" +
                    "    \"code\": 1,\n" +
                    "    \"msg\": \"成功\",\n" +
                    "    \"data\": { \n" +
                    "        // 结果内容\n" +
                    "    }\n" +
                    "}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("### 异常示例\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n");
            apiDoc.append("  \"success\": false,\n");
            apiDoc.append("  \"code\": -1,\n");
            apiDoc.append("  \"msg\": \"error\",\n");
            apiDoc.append("  \"data\": null\n");
            apiDoc.append("}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("---\n");
            System.out.println(apiDoc);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return apiDoc.toString();
    }


    private static void createParam(StringBuilder apiDoc, Field[] returnTypeFields) throws ClassNotFoundException {
        Set<Class> expendTypes = new HashSet<>();
        apiDoc.append("\n");
        apiDoc.append("|  参数   | 类型  |  必须   | 描述   |\n");
        apiDoc.append("|  ----  | ----  |  ----  | ----  |\n");
        for (Field field : returnTypeFields) {
            if ("apiContext".equals(field.getName())) {
                continue;
            }

            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                continue;
            }

            Type expendType = field.getType();
            String fieldTypeName = field.getType().getSimpleName();
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType) field.getGenericType();
                String typeName = genericType.getActualTypeArguments()[0].getTypeName();
                String actualTypeArgument = typeName.substring(typeName.lastIndexOf(".") + 1);
                fieldTypeName = fieldTypeName + "\\<" + actualTypeArgument + "\\>";
                expendType = genericType.getActualTypeArguments()[0];
            }

            OpenModelProperty annotation = field.getAnnotation(OpenModelProperty.class);
            String isNeed = annotation == null || !annotation.required() ? "否" : "是";
            String name = annotation == null ? "" : annotation.name();
            String example = annotation == null ? "" : annotation.example();

            String str = "|  " + field.getName() + " | " + fieldTypeName + " | " + isNeed + "  | " + name + " <br>**示例值：" + example + "**|\n";
            apiDoc.append(str);


            Class<?> expendClass = Class.forName(expendType.getTypeName());
            if (!isBasic(expendClass.getName()) && !expendClass.getClass().isPrimitive()) {
                expendTypes.add(expendClass);
            }
        }
        for (Class expendType : expendTypes) {
            apiDoc.append("\n");
            apiDoc.append("**" + expendType.getSimpleName() + "**\n");
            createParam(apiDoc, expendType.getDeclaredFields());
        }
    }

    private static Boolean isBasic(String name) {
        return name.contains("java.lang") || name.contains("java.util");
    }

}
