package cn.com.duiba.cloud.openapi.service.base.model;

import lombok.Data;

import java.io.Serializable;

/**
 * api上下文
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/6/27 4:59 下午
 **/
@Data
public class ApiContext implements Serializable {
    private static final long serialVersionUID = -8685316747866138917L;
    /**
     * 应用id
     */
    private Long appId;

    /**
     * 应用名
     */
    private String appName;

    /**
     * 应用类型
     */
    private Integer appType;

    /**
     * cid，当参数有uid时才会转换
     */
    private Long cid;

    /**
     * 租户信息
     */
    private TenantInfo tenantInfo;

    @Data
    public static class TenantInfo implements Serializable {
        private static final long serialVersionUID = -3544247228074609498L;
        /**
         * 租户id
         */
        private Long tenantId;
        /**
         * 租户应用名
         */
        private String tenantAppName;
    }
}
