/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.openapi.service.base.utils;

import cn.com.duiba.cloud.openapi.service.base.annotation.OpenApi;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenModel;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenModelProperty;
import cn.com.duiba.cloud.openapi.service.base.annotation.OpenPath;
import cn.hutool.core.lang.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;

public class OpenApiDocUtil {
    public static String createApiDoc(Method method) {
        StringBuilder apiDoc = new StringBuilder();
        try {
            OpenApi openApi = method.getDeclaringClass().getDeclaredAnnotation(OpenApi.class);
            OpenPath openPath = method.getDeclaredAnnotation(OpenPath.class);
            if (openApi != null && openPath != null) {
                apiDoc.append("# " + openPath.apiDesc() + "\n");
                apiDoc.append("\n");
                apiDoc.append("---\n");
                apiDoc.append("\n");
                apiDoc.append("## " + openApi.prefix() + openPath.apiPath() + "\n");
                apiDoc.append("\n");
                apiDoc.append("\u63a5\u53e3\u63cf\u8ff0\uff1a" + openPath.apiDesc() + "\n");
            }
            apiDoc.append("> \u514d\u8d39 \uff5c \u5fc5\u987b\u7528\u6237\u6388\u6743 \uff5c \u7248\u672c1.0\n");
            apiDoc.append("\n");
            apiDoc.append("## \u8bf7\u6c42\u65b9\u5f0f\n");
            apiDoc.append("\n");
            apiDoc.append("**POST**\n");
            apiDoc.append("\n");
            apiDoc.append("## \u8bf7\u6c42\u4f53\u53c2\u6570\n");
            apiDoc.append("\n");
            Class<?> type = method.getParameters()[0].getType();
            Assert.isFalse((boolean)type.isPrimitive(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b", (Object[])new Object[0]);
            OpenModel annotationParam = type.getAnnotation(OpenModel.class);
            if (annotationParam != null) {
                apiDoc.append(annotationParam.name() + ":" + annotationParam.description());
                apiDoc.append("\n");
            }
            Field[] paramFields = type.getDeclaredFields();
            OpenApiDocUtil.createParam(apiDoc, paramFields);
            apiDoc.append("\n");
            apiDoc.append("## \u54cd\u5e94\u53c2\u6570\n");
            apiDoc.append("\n");
            Assert.isFalse((boolean)method.getReturnType().isPrimitive(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b", (Object[])new Object[0]);
            OpenModel annotationReturn = method.getReturnType().getAnnotation(OpenModel.class);
            if (annotationReturn != null) {
                apiDoc.append(annotationReturn.name() + ":" + annotationReturn.description());
                apiDoc.append("\n");
            }
            if (!method.getReturnType().getName().contains("java.lang")) {
                Field[] returnTypeFields = method.getReturnType().getDeclaredFields();
                OpenApiDocUtil.createParam(apiDoc, returnTypeFields);
            }
            apiDoc.append("\n");
            apiDoc.append("## \u8bf7\u6c42\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("\n");
            apiDoc.append("{\n    \"sign\": \"445F5858242040FB3EB7CEA3975C2905\",\n    \"appKey\": \"f1faaa61e7ce9aa75d3deec74f008310\",\n    \"timestamp\": \"1646896566529\",\n    \"param\": {\n        //\u8bf7\u6c42\u4f53\u53c2\u6570\n    }\n}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("## \u54cd\u5e94\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n    \"success\": true,\n    \"code\": 1,\n    \"desc\": \"\u6210\u529f\",\n    \"data\": { \n        // \u7ed3\u679c\u5185\u5bb9\n    }\n}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("## \u5f02\u5e38\u793a\u4f8b\n");
            apiDoc.append("\n");
            apiDoc.append("```json\n");
            apiDoc.append("{\n");
            apiDoc.append("  \"success\": false,\n");
            apiDoc.append("  \"code\": -1,\n");
            apiDoc.append("  \"desc\": \"error\",\n");
            apiDoc.append("  \"data\": null\n");
            apiDoc.append("}\n");
            apiDoc.append("```\n");
            apiDoc.append("\n");
            apiDoc.append("## \u7ed3\u679c\u7801\n");
            apiDoc.append("| \u53c2\u6570\u540d  |  \u53c2\u6570   |\n");
            apiDoc.append("|  ----  |  ----  | \n");
            apiDoc.append("---\n");
            System.out.println(apiDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiDoc.toString();
    }

    private static void createParam(StringBuilder apiDoc, Field[] returnTypeFields) throws ClassNotFoundException {
        HashSet expendTypes = new HashSet();
        apiDoc.append("\n");
        apiDoc.append("|  \u53c2\u6570   | \u7c7b\u578b  |  \u5fc5\u987b   | \u63cf\u8ff0   |\n");
        apiDoc.append("|  ----  | ----  |  ----  | ----  |\n");
        for (Field field : returnTypeFields) {
            OpenModelProperty annotation;
            if ("apiContext".equals(field.getName()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Type expendType = field.getType();
            String fieldTypeName = field.getType().getSimpleName();
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                String typeName = genericType.getActualTypeArguments()[0].getTypeName();
                String actualTypeArgument = typeName.substring(typeName.lastIndexOf(".") + 1);
                fieldTypeName = fieldTypeName + "\\<" + actualTypeArgument + "\\>";
                expendType = genericType.getActualTypeArguments()[0];
            }
            String isNeed = (annotation = field.getAnnotation(OpenModelProperty.class)) == null || !annotation.required() ? "\u5426" : "\u662f";
            String name = annotation == null ? "" : annotation.name();
            String example = annotation == null ? "" : annotation.example();
            String str = "|  " + field.getName() + " | " + fieldTypeName + " | " + isNeed + "  | " + name + " <br>**\u793a\u4f8b\u503c\uff1a" + example + "**|\n";
            apiDoc.append(str);
            Class<?> expendClass = Class.forName(expendType.getTypeName());
            if (OpenApiDocUtil.isBasic(expendClass.getName()).booleanValue() || expendClass.getClass().isPrimitive()) continue;
            expendTypes.add(expendClass);
        }
        for (Class clazz : expendTypes) {
            apiDoc.append("\n");
            apiDoc.append("**" + clazz.getSimpleName() + "**\n");
            OpenApiDocUtil.createParam(apiDoc, clazz.getDeclaredFields());
        }
    }

    private static Boolean isBasic(String name) {
        return name.contains("java.lang") || name.contains("java.util");
    }
}

