/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.openapi.web.api.config;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.duiba.openapi.web.api.dto.ConsumerCookieDTO;
import cn.com.duiba.cloud.duiba.openapi.web.api.dto.LoginCookieDTO;
import cn.com.duiba.cloud.duiba.openapi.web.api.param.AutoLoginAllParam;
import cn.com.duiba.cloud.duiba.openapi.web.api.param.DecryptDataParam;
import cn.com.duiba.cloud.duiba.openapi.web.api.remoteservice.RemoteAutoLoginService;
import cn.com.duiba.cloud.duiba.openapi.web.api.utils.CookieUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenRequest {
    private static final Logger log = LoggerFactory.getLogger(OpenRequest.class);

    public static ConsumerCookieDTO getConsumerInfo() throws BizException {
        Cookie[] cookies;
        String timestamp = "";
        String encodeConsumerData = "";
        for (Cookie cookie : cookies = CookieUtil.getCookies()) {
            if ("open_timestamp".equals(cookie.getName())) {
                timestamp = cookie.getValue();
                continue;
            }
            if (!"open_consumer_data".equals(cookie.getName())) continue;
            encodeConsumerData = cookie.getValue();
        }
        if (StringUtils.isBlank((CharSequence)timestamp) || StringUtils.isBlank((CharSequence)encodeConsumerData)) {
            return null;
        }
        try {
            RemoteAutoLoginService remoteAutoLoginService = (RemoteAutoLoginService)SpringUtil.getApplicationContext().getBean(RemoteAutoLoginService.class);
            DecryptDataParam decryptDataParam = DecryptDataParam.builder().data(encodeConsumerData).timestamp(Long.valueOf(timestamp)).build();
            String dataJson = remoteAutoLoginService.cookieDataDecrypt(decryptDataParam);
            return (ConsumerCookieDTO)JSON.parseObject((String)dataJson, ConsumerCookieDTO.class);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25,\u53ef\u80fd\u767b\u9646\u4fe1\u606f\u5df2\u8fc7\u671f\u6216\u8005\u5047\u6570\u636e", (Throwable)e);
            return null;
        }
    }

    public static String getTransfer() {
        return CookieUtil.getCookieValue("transfer");
    }

    public static String getDCustom() throws UnsupportedEncodingException {
        String dCustomValue = CookieUtil.getCookieValue("dcustom");
        if (StringUtils.isBlank((CharSequence)dCustomValue)) {
            return null;
        }
        return URLDecoder.decode(dCustomValue, "utf-8");
    }

    public static void initConsumerAndCookie(AutoLoginAllParam param) throws UnsupportedEncodingException {
        RemoteAutoLoginService remoteAutoLoginService = (RemoteAutoLoginService)SpringUtil.getApplicationContext().getBean(RemoteAutoLoginService.class);
        LoginCookieDTO loginCookieDTO = remoteAutoLoginService.autoLoginPre(param);
        OpenRequest.setLoginCookie(loginCookieDTO);
    }

    public static void setLoginCookie(LoginCookieDTO param) throws UnsupportedEncodingException {
        Long loginTime = System.currentTimeMillis();
        String domain = param.getDomain();
        CookieUtil.setCookie("open_consumer_data", param.getUserEncryptCookieVal());
        CookieUtil.setCookie("open_timestamp", loginTime.toString());
        CookieUtil.setCrossCookieFor24Hour("is_not_login_user", String.valueOf(OpenRequest.isNotLoginUser(param.getPartnerUserId())), domain);
        String transfer = param.getTransfer();
        if (StringUtils.isNotBlank((CharSequence)transfer) && transfer.length() < 100) {
            CookieUtil.setCrossCookieFor24Hour("transfer", transfer, domain);
        } else {
            CookieUtil.deleteCookie("transfer", domain);
        }
        String dcustom = param.getDcustom();
        if (StringUtils.isNotBlank((CharSequence)dcustom)) {
            dcustom = EscapeUtil.unescapeHtml4((CharSequence)dcustom);
            CookieUtil.setCrossCookieFor24Hour("dcustom", URLEncoder.encode(dcustom, "utf-8"), domain);
        } else {
            CookieUtil.deleteCookie("dcustom", domain);
        }
    }

    private static boolean isNotLoginUser(String partnerUserId) {
        return StringUtils.isNotBlank((CharSequence)partnerUserId) && ("not_login".equals(partnerUserId) || partnerUserId.startsWith("gen_new_") || "preview_user".equals(partnerUserId));
    }
}

