/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.openapi.web.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CookieUtil {
    public static String getCookieValue(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = CookieUtil.getRequest().getCookies()) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static Cookie[] getCookies() {
        return CookieUtil.getRequest().getCookies();
    }

    private static Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        return cookie;
    }

    public static void setCookie(String name, String value) {
        Cookie cookie = CookieUtil.createCookie(name, value);
        cookie.setSecure(true);
        CookieUtil.getResponse().addCookie(cookie);
    }

    public static Cookie createSession24Cookie(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setMaxAge(86400);
        return cookie;
    }

    public static void setCrossCookie4Today(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setDomain(domain);
        Date now = new Date();
        cookie.setMaxAge((int)(DateUtils.getDayEndTime((Date)now).getTime() - now.getTime()) / 1000);
        CookieUtil.getResponse().addCookie(cookie);
    }

    public static void setCrossCookieFor24Hour(String name, String value, String domain) {
        Cookie cookie = CookieUtil.createSession24Cookie(name, value, domain);
        CookieUtil.getResponse().addCookie(cookie);
    }

    public static void deleteCookie(String name, String domain) {
        Cookie cookie = CookieUtil.createCookie(name, null);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setMaxAge(0);
        CookieUtil.getResponse().addCookie(cookie);
    }

    private static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getResponse();
    }

    private static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
    }
}

