package cn.com.duiba.cloud.duiba.openapi.web.api.enums;

import lombok.Getter;

/**
 * 结果码
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/27 10:12 上午
 **/
@Getter
public enum ApiResultCodeEnum {
    /**
     * 结果码
     */
    SUCCESS(1, "成功"),
    FAIL(-1, "失败"),
    UNAUTHORIZED(401, "验证授权码失败"),
    LIMIT(429, "触发限流"),
    ;


    private Integer value;

    private String desc;

    ApiResultCodeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ApiResultCodeEnum item : ApiResultCodeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static ApiResultCodeEnum valueOf(Integer value) {
        for (ApiResultCodeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
