package cn.com.duiba.cloud.duiba.openapi.web.api.param;

import lombok.Data;
import lombok.experimental.FieldNameConstants;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 免登用户参数-all
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/18 5:38 下午
 **/
@Data
@FieldNameConstants
public class AutoLoginAllParam implements Serializable {

    private static final long serialVersionUID = -6999996983512461262L;
    /**
     * 登录时间戳
     */
    @NotNull(message = "时间戳不能为空")
    private Long timestamp;

    /**
     * appKey
     */
    @NotNull(message = "appKey不能为空")
    private String appKey;

    @NotNull(message = "用户数据不能为空")
    private AutoLoginCustomParam customData;
}
