package cn.com.duiba.cloud.duiba.openapi.web.api.param;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据解密参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/22 10:34 上午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DecryptDataParam implements Serializable {
   private static final long serialVersionUID = -5716896610837919027L;
   /**
     * 加密的内容
     */
    @NotNull(message = "加密的内容不能为空")
    private String data;

    /**
     * 加密的时间戳
     */
    @NotNull(message = "加密的时间戳不能为空")
    private Long timestamp;
}
