package cn.com.duiba.cloud.duiba.openapi.web.api.dto;

import cn.com.duiba.cloud.duiba.openapi.web.api.enums.ApiResultCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 路由结果 controller用
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 10:29 上午
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RouteApiResult implements Serializable {
    private static final long serialVersionUID = -3549923843295208345L;
    private Boolean success;
    /**
     * 结果码
     * {@link cn.com.duiba.cloud.duiba.openapi.web.api.enums.ApiResultCodeEnum}
     */
    private Integer code;

    private String desc;

    /**
     * 数据结果
     */
    private Object data;

    public RouteApiResult(Object data) {
        this.data = data;
        this.success = true;
        this.code = ApiResultCodeEnum.SUCCESS.getValue();
        this.desc = ApiResultCodeEnum.SUCCESS.getDesc();
    }

    /**
     * 成功
     *
     * @param data
     * @return
     */
    public static RouteApiResult success(Object data) {
        return new RouteApiResult(data);
    }

    /**
     * 失败
     *
     * @param desc
     * @return
     */
    public static RouteApiResult fail(String desc) {
        RouteApiResult routeApiResultVO = new RouteApiResult();
        routeApiResultVO.setSuccess(false);
        routeApiResultVO.setCode(ApiResultCodeEnum.FAIL.getValue());
        routeApiResultVO.setDesc(desc);
        return routeApiResultVO;
    }

    public static RouteApiResult fail(Integer code, String desc) {
        RouteApiResult routeApiResultVO = new RouteApiResult();
        routeApiResultVO.setSuccess(false);
        routeApiResultVO.setCode(code);
        routeApiResultVO.setDesc(desc);
        return routeApiResultVO;
    }

    public static RouteApiResult fail(ApiResultCodeEnum result) {
        RouteApiResult routeApiResultVO = new RouteApiResult();
        routeApiResultVO.setSuccess(false);
        routeApiResultVO.setCode(result.getValue());
        routeApiResultVO.setDesc(result.getDesc());
        return routeApiResultVO;
    }

    public static RouteApiResult fail(ApiResultCodeEnum result, String desc) {
        RouteApiResult routeApiResultVO = new RouteApiResult();
        routeApiResultVO.setSuccess(false);
        routeApiResultVO.setCode(result.getValue());
        routeApiResultVO.setDesc(desc);
        return routeApiResultVO;
    }
}
