package cn.com.duiba.cloud.duiba.openapi.web.api.param;

import lombok.Data;
import lombok.experimental.FieldNameConstants;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 免登用户参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/18 5:38 下午
 **/
@Data
@FieldNameConstants
public class AutoLoginCustomParam implements Serializable {

    private static final long serialVersionUID = -6060955073109687643L;
    /**
     * 开发者用户id
     */
    @NotBlank(message = "uid不能为空")
    private String uid;

    /**
     * app体系内vip级别
     * map的json  key-组 value-等级
     */
    private String vipGroup;

    /**
     * 用户积分余额
     */
    private Long credits;

    /**
     * 自定义参数,JSON
     * @see AutoLoginDCustomParam
     */
    private String dcustom;

    /**
     * 兑吧回传参数
     */
    private String transfer;

}
