package cn.com.duiba.cloud.duiba.openapi.web.api.param;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;

/**
 * Rpc api路由参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 10:34 上午
 **/
@Data
public class RouteApiParam implements Serializable {
    private static final long serialVersionUID = 7887014735727691013L;

    /**
     * api地址，具体地址参考开放文档
     * 比如查询账单接口：payment/queryAccountBill
     * 注意apiPath 前缀不要加"/"
     */
    private String apiPath;

    /**
     * 应用key
     */
    private String appKey;

    /**
     * 请求参数，请根据开放文档进行传参
     */
    private JSONObject param;

}



