package cn.com.duiba.cloud.duiba.openapi.web.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.web.api.dto.RouteApiResult;
import cn.com.duiba.cloud.duiba.openapi.web.api.param.RouteApiParam;

/**
 * api路由接口
 * 用于内部通过feign调开放平台接口的入口
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 10:26 上午
 **/
@AdvancedFeignClient
public interface RemoteRouteApiService {

    /**
     * API路由接口，feign调开放平台方法
     * 不需要走token认证，需要传appKey做应用区分
     * 具体参考开放文档
     *
     * @param param
     * @return
     */
    RouteApiResult routeApi(RouteApiParam param) throws BizException;
}
