package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 任务类型枚举类
 * @Author dangcang
 * @Date 2021/11/8 6:21 下午
 **/
@Getter
public enum BatchTypeEnum {

    BATCH_SHIPMENT(1,"实物批量发货"),
    BATCH_UPDATE_LOGISTICS(2, "实物批量修改物流"),
    COUPON_GOODS_DELIVERY(3, "卡券批量发货"),
    BATCH_EXCEPTION_HANDLE_FAIL(4, "异常订单批量处理失败"),
    BATCH_EXCEPTION_HANDLE_SUCCESS(5, "异常订单批量处理成功"),
    ;

    private Integer type;

    private String desc;

    BatchTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static Map<Integer, BatchTypeEnum> map = new HashMap<Integer, BatchTypeEnum>() {{
        for (BatchTypeEnum batchTypeEnum : BatchTypeEnum.values()) {
            put(batchTypeEnum.getType(), batchTypeEnum);
        }
    }};

    public static BatchTypeEnum getByType(Integer type) {
        return map.get(type);
    }

}