package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * 供应商枚举类型
 *
 * @author zouwx
 * @date 2022/05/27
 */
@Getter
public enum SupplierTypeEnum {

    /**
     * 状态码
     */
    XIANGSHNG("xiangshang", "向上"),
    PUSHANG("pushang", "浦上"),
    FULU("fulu", "福禄"),
    ;

    private final String supplyCode;
    private final String desc;

    SupplierTypeEnum(String supplyCode, String desc) {
        this.supplyCode = supplyCode;
        this.desc = desc;
    }

    public static SupplierTypeEnum getByCode(String code) {
        for (SupplierTypeEnum supplyEnum : SupplierTypeEnum.values()) {
            if (supplyEnum.getSupplyCode().equals(code)) {
                return supplyEnum;
            }
        }
        return null;
    }

    public String getSupplyCode() {
        return supplyCode;
    }

    public String getDesc() {
        return desc;
    }

}
