package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单详情
 * @Author dangcang
 * @Date 2021/11/10 5:50 下午
 **/
@Data
public class OrderDetailDTO implements Serializable {

    private static final long serialVersionUID = 452659024024576399L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 应用id 下单的应用id buyerAppId;
     */
    private Long appId;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 买家备注
     */
    private String remark;

    /**
     * 业务主体
     */
    private Integer businessEntityType;

    /**
     * 是否含税
     */
    private Boolean hasTax;

    /**
     * 商品信息
     */
    private List<SubOrderDetailDTO> subOrderDetailDTOS;

    /**
     * 收货人信息
     */
    private ReceiverUserDTO receiverUserDTO;

    /**
     * 付款信息
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠项信息
     */
    private List<DiscountDTO> discountDTOS;

    /**
     * 扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;

}