package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description CreateOrderDTO
 * @Author dangcang
 * @Date 2021/11/10 1:53 下午
 **/
@Data
public class PayDTO implements Serializable {

    private static final long serialVersionUID = -4644499577953202388L;

    /**
     * 支付单号
     */
    private String payNo;

    /**
     * 订单号
     */
    private List<SimpleOrderCodeDTO> orderDTOS;

    /**
     * 是否成功创建订单 false = 未成功创建订单
     * 可能原因
     * 库存不足
     * 商品数据不存在
     * 参数校验未通过
     * 等等
     */
    private Boolean success;

    /**
     * 这里是错误原因
     */
    private String errorMsg;

}