package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/16 7:29 下午
 **/
@Data
public class PhysicalGoodsDTO implements Serializable {

    private static final long serialVersionUID = -3991610167622261784L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 收货地址
     */
    private String addressDetail;

    /**
     * 收货人联系方式
     */
    private String receiverPhone;

    /**
     * geo编码
     */
    private String postcode;

    /**
     * 收件人姓名
     */
    private String receiverName;

    /**
     * 物流单id
     */
    private Long logisticsId;

    /**
     * 发货人
     */
    private String deliveryName;

    /**
     * 发货时间
     */
    private Long deliveryTime;

    /**
     * 自动确认收货时间
     */
    private Long autoConfirmTime;

    /**
     * 快递公司
     */
    private String logisticsCompany;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 发货单状态
     * @see cn.com.duiba.cloud.order.center.api.enums.DispatchBillStatusEnum
     */
    private Integer dispatchBillStatus;

    /**
     * 发货方式
     * 计算得出 当 dispatchBillStatus = 2 且 logisticsId = 0时 表示无需物流 deliveryType = 1
     * @see cn.com.duiba.cloud.order.center.api.enums.DeliveryTypeEnum
     */
    private Integer deliveryType;

}