package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 取消订单
 * @Author dangcang
 * @Date 2021/11/10 6:05 下午
 **/
@Data
public class CancelOrderParam implements Serializable {

    private static final long serialVersionUID = -7184742869617957731L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号相关
     */
    private List<CancelOrderRollBackParam> rollBackParams;

    /**
     * 是否租户取消订单(包括兑吧后台)
     */
    private Boolean fromTenant = Boolean.TRUE;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 仅当异常处理的时候需要传此参数
     * true 表示当前取消操作来自于异常订单处理
     */
    private Boolean fromExceptionHandle = Boolean.FALSE;

    /**
     * 仅在支付结果通知接口的取消需要传此参数
     * true 表示当前取消操作来自于支付结果处理
     */
    private Boolean fromPayResult = Boolean.FALSE;
}