package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/12/20 9:18 上午
 **/
@Data
public class PayResultParam implements Serializable {

    public static final String UNPAID = "取消支付";

    public static final String UNCLAIMED = "超时未领取";

    private static final long serialVersionUID = -3693256894593916068L;
    /**
     * 支付结果订单号
     */
    private String orderCode;

    /**
     * 支付结果
     * true = 将修改到待支付后续状态
     * false = 将修改到订单取消状态
     */
    private Boolean payResult;

    /**
     * payResult = false时可选填
     * 不填会有默认值
     */
    private String failReason;

    /**
     * 收货人信息 活动订单需要
     */
    private ReceiverUserParam receiverUserParam;
}