package cn.com.duiba.cloud.order.center.api.openapi.model.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/7/11 2:33 下午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OpenOrderDTO implements Serializable {

    private static final long serialVersionUID = -7539141304995991393L;
    /**
     * 接口appKey，应用的唯一标识
     */
    private String appKey;

    /**
     * 请求时间戳
     */
    private String timestamp;

    /**
     * 开发者用户id
     */
    private String uid;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 开发者订单号（扣积分时返回）
     */
    private String developBizId;

    /**
     * 下单时间，单位：时间戳，下单时间毫秒值
     */
    private Long createTime;

    /**
     * 订单完结时间，单位：时间戳，订单完结时间毫秒值
     */
    private Long finishTime;

    /**
     * 用户消耗的总积分
     */
    private Long totalCredits;

    /**
     * 用户支付的总金额，单位：分
     */
    private Long consumerPayPrice;

    /**
     * 订单来源：普兑；活动
     */
    private String source;

    /**
     * 订单来源的活动名称
     */
    private String sourceName;

    /**
     * 订单状态：待支付，待审核，待发货，交易完成，异常状态，交易成功，交易关闭
     */
    private String orderStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 子订单信息item
     */
    private List<OpenSubOrderDTO> orderItemList;

    /**
     * 运费，单位：分
     */
    private Long expressPrice;

    /**
     * 直充账号
     */
    private String account;

    /**
     * 收货地址信息（实物商品必填）
     */
    private OpenAddressDTO receiveAddressInfo;

    /**
     * 签名md5
     */
    private String sign;
}