package cn.com.duiba.cloud.order.center.api.openapi.model.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/7/11 2:33 下午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OpenSubOrderDTO implements Serializable {

    private static final long serialVersionUID = -26614178862152551L;
    /**
     * 商品类型：实物、优惠券、充值
     */
    private String type;

    /**
     * 商品名称
     */
    private String title;

    /**
     * 是否为开发者自有商品 0否1是
     */
    private Integer isSelf;

    /**
     * 商品主图
     */
    private String smallImage;

    /**
     * 商品编码
     */
    private Long skuId;

    /**
     * 规格编码
     */
    private String skuCode;

    /**
     * 供应商编码
     */
    private String merchantCode;

    /**
     * 商品售价：积分
     */
    private Long perCredit;

    /**
     * 商品售价：人民币，单位：分
     */
    private Long perPrice;

    /**
     * 购买数量
     */
    private Long quantity;

    /**
     * 优惠券码（优惠券/卡密必填）
     */
    private String code;

    /**
     * 密码（卡密必填）
     */
    private String password;

    /**
     * 优惠券有效期开始时间（优惠券/卡密必填），单位：时间戳，优惠券有效期开始时间毫秒值
     */
    private Long cardBeginTime;

    /**
     * 优惠券有效期结束时间（优惠券/卡密必填），单位：时间戳，优惠券有效期结束时间毫秒值
     */
    private Long cardEndTime;

    /**
     * 物流单号（实物必填）
     */
    private String deliveryCompanyNo;

    /**
     * 物流公司（实物必填）
     */
    private String deliveryCompanyName;

    /**
     * 供货价金额，单位：分
     */
    private Long duibaSupplyPrice;
}