package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/17 6:19 下午
 **/
@Data
public class OpenUpdateLogisticsParam implements Serializable {

    private static final long serialVersionUID = 4486072473093534863L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 该物流单所运输的子订单序号
     */
    @NotNull(message = "子订单序号不能为空")
    private Long orderSort;

    /**
     * 快递公司
     * @see @see cn.com.duiba.cloud.order.center.api.enums.ExpressCodeEnum
     */
    @NotBlank(message = "快递公司不能为空")
    private String logisticsCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "物流单号不能为空")
    private String logisticsNo;
}