package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.param.virtual.RechargeGoodsDeliveryParam;
import cn.com.duiba.cloud.order.center.api.model.param.virtual.VirtualGoodsBatchDeliveryParam;

import java.util.List;

/**
 * @Description 订单虚拟商品(卡券、充值等)写相关
 * @Author dangcang
 * @Date 2022/4/3 4:11 下午
 **/
@AdvancedFeignClient
public interface RemoteVirtualGoodsWriteService {

    /**
     * 卡券商品批量发货
     * @param param
     * @return
     * @throws BizException
     */
    Boolean batchGoodsDelivery(VirtualGoodsBatchDeliveryParam param) throws BizException;

    /**
     * 开发者自有充值商品批量发货
     * @param params
     * @return
     * @throws BizException
     */
    Boolean batchRechargeGoodsDelivery(List<RechargeGoodsDeliveryParam> params) throws BizException;
}