package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * @Description 支付状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 3:59 下午
 **/
@Getter
public enum PayStatusEnum {

    WAIT_PAY(1,"待支付"),
    PAID(2,"已支付"),
    CANCELED(3,"已取消"),
    REFUND(4, "已退款"),
    ;


    private Integer status;

    private String desc;

    PayStatusEnum(Integer status, String desc) {
        this.desc = desc;
        this.status = status;
    }

}