package cn.com.duiba.cloud.order.center.api.model.dto.logistics;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 发货单
 * @Author dangcang
 * @Date 2021/11/18 12:02 下午
 **/
@Data
public class DispatchBillDTO implements Serializable {

    /**
     * 发货单id
     */
    private Long DispatchBillId;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 地址id
     */
    private OrderAddressDTO orderAddressDTO;

    /**
     * 物流单id
     */
    private Long logisticsId;

    /**
     * 快递公司
     */
    private String logisticsCompany;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 发货单状态
     * @see cn.com.duiba.cloud.physical.goods.service.api.enums.DispatchBillStatusEnum
     */
    private Integer dispatchBillStatus;

    /**
     * 发货人
     */
    private String deliveryName;

    /**
     * 发货时间
     */
    private Long deliveryTime;

    /**
     * 运费 单位分
     */
    private Long freight;
}