package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 子订单商品销售价格、方式信息
 * @Author dangcang
 * @Date 2021/11/10 4:24 下午
 **/
@Data
public class PaymentDTO implements Serializable {

    private static final long serialVersionUID = 8145137900861004410L;

    /**
     * 订单code
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 支付类型
     */
    private Integer payType;

    /**
     * 支付数量(法定货币单位：分，虚拟货币单位：个)
     */
    private Long payNumber;

    /**
     * 支付批次
     */
    private Integer paymentLevel;

    /**
     * 支付状态
     */
    private Integer payStatus;

    /**
     * 开始支付时间 毫秒级时间戳
     */
    private Long paymentStartTime;

    /**
     * 截止支付时间 毫秒级时间戳
     */
    private Long paymentEndTime;

}