package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 订单用户信息
 * @Author dangcang
 * @Date 2021/11/10 2:16 下午
 **/
@Data
public class UserParam implements Serializable {

    private static final long serialVersionUID = 3928768643187629699L;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer buyerType;

    /**
     * 卖家id 即租户id
     */
    private Long sellerId;

    /**
     * 卖家类型
     *  @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer sellerType;
}