package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/25 3:45 下午
 **/
@Data
public class OpenBatchDeliverGoodsParam implements Serializable {

    private static final long serialVersionUID = -7970091901226813254L;
    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;

    /**
     * 发货参数
     */
    @Valid
    @NotEmpty(message = "发货参数不能为空")
    private List<OpenDeliverGoodsParam> deliverGoodsParams;
}