package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 取消订单
 * @Author dangcang
 * @Date 2021/11/10 6:05 下午
 **/
@Data
public class OpenCancelOrderParam implements Serializable {

    private static final long serialVersionUID = -7184742869617957731L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 子订单号
     */
    private List<Long> orderSortList;

    /**
     * 返还库存类型
     * 老兑吧定制需求
     * 非定制需求切勿填值
     *
     * @see cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam.RollbackTypeEnum
     */
    @Deprecated
    @Min(value = 1)
    @Max(value = 2)
    private Integer rollBackType;

    /**
     * 是否租户取消订单
     */
    private Boolean fromTenant = Boolean.TRUE;

    /**
     * 取消原因
     */
    @NotBlank(message = "取消原因不能为空")
    private String cancelReason;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}