package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/10 4:35 下午
 **/
@Data
public class OpenUpdateAfterSaleParam implements Serializable {

    private static final long serialVersionUID = -2440534062799058089L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 子订单序号
     */
    @NotNull(message = "子订单号不能为空")
    private Long orderSort;

    /**
     * 售后单号
     */
    @NotBlank(message = "售后单号不能为空")
    private String afterSaleNumber;

    /**
     * 售后单状态
     * @see cn.com.duiba.cloud.order.center.api.enums.AfterSaleStatusEnum
     */
    @NotNull(message = "售后单状态不能为空")
    private Integer afterSaleStatus;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}