package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * @Description 售后状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 4:52 下午
 **/
@Getter
public enum AfterSaleStatusEnum {

    AFTER_SALE(1,"售后中"),
    AFTER_SALE_SUCCESS(2,"售后成功"),
    REJECT(3,"拒绝售后"),
    CANCELED(4,"取消售后"),
    NONE(5, "无售后"),
    ;

    private Integer status;

    private String desc;

    AfterSaleStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
}