package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/8 1:13 下午
 **/
@Getter
public enum ExportTypeEnum {

    MAIN_ORDER_EXPORT(1,"主订单分页列表导出"),
    SUB_ORDER_EXPORT(2,"子订单分页列表导出"),
    SUB_ORDER_TO_DUIBA_EXPORT(3,"子订单分页列表导出-兑吧管理后台"),
    SUB_ORDER_TO_TENANT_EXPORT(4,"子订单分页列表导出-租户管理后台"),

    ;

    private Integer type;

    private String desc;

    ExportTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ExportTypeEnum getExportDataTypeEnum(Integer type){
        for (ExportTypeEnum value : ExportTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value;
            }
        }
        return null;
    }
}