package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单信息
 * @Author dangcang
 * @Date 2021/11/10 3:36 下午
 **/
@Data
public class OrderDTO implements Serializable {

    private static final long serialVersionUID = -8374570092334195500L;

    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 下单终端环境
     */
    private String environment;

    /**
     * 购买方appId
     */
    private Long buyerAppId;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 子订单列表
     */
    private List<SubOrderDTO> subOrderDTOS;

    /**
     * 扩展信息
     */
    private List<OrderExtraDTO> orderExtraDTOS;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private String bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;
}