package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.logistics.OrderAddressDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.logistics.UserAddressDTO;
import cn.com.duiba.cloud.order.center.api.model.param.logistics.AddressQueryParam;

import java.util.List;

/**
 * @Description 用户地址相关读操作接口
 * @Author dangcang
 * @Date 2021/11/11 10:36 上午
 **/
@AdvancedFeignClient
public interface RemoteAddressReadService {

    /**
     * 获取用户地址列表
     * @param param
     * @return
     * @throws BizException
     */
    @Deprecated
    List<UserAddressDTO> getAddressList(AddressQueryParam param) throws BizException;

    /**
     * 获取用户地址
     * @param addressId
     * @return
     * @throws BizException
     */
    @Deprecated
    UserAddressDTO getAddressById(Long addressId) throws BizException;

    /**
     * 获取订单地址
     * @param orderCode
     * @return
     * @throws BizException
     */
    OrderAddressDTO findOrderAddressByOrderCode(String orderCode) throws BizException;

    /**
     * 批量获取订单收货地址
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<OrderAddressDTO> batchOrderAddressList(List<String> orderCodeList) throws BizException;
}