package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.virtual.VirtualGoodsDeliveryDTO;
import cn.com.duiba.cloud.order.center.api.model.param.virtual.VirtualGoodsDeliveryQueryParam;

import java.util.List;

/**
 * @Description 订单虚拟商品(卡券、充值等)读相关
 * @Author dangcang
 * @Date 2022/4/3 4:11 下午
 **/
@AdvancedFeignClient
public interface RemoteVirtualGoodsReadService {

    /**
     * 虚拟商品发货信息
     * @param params
     * @return
     * @throws BizException
     */
    List<VirtualGoodsDeliveryDTO> findVirtualGoodsDeliveryInfo(List<VirtualGoodsDeliveryQueryParam> params) throws BizException;
}