package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 10:59 上午
 **/
@Data
public class OpenCancelOrderRollBackParam implements Serializable {

    private static final long serialVersionUID = -3254259171055514034L;

    /**
     * 子订单序号
     */
    private Long orderSort;


    /**
     * 返还库存类型
     * 老兑吧定制需求
     * 非定制需求切勿填值
     *
     * @see cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam.RollbackTypeEnum
     */
    @Deprecated
    @Min(value = 1)
    @Max(value = 2)
    private Integer rollBackType;
}