package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 订单状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 2:13 下午
 **/
@Getter
public enum OrderStatusEnum {

    CHECK_PARAM(-1, "参数校验"),
    INIT(0, "初始状态,仅用于根据订单类型创建参数"),
    AFTER_CREATE_ORDER(1, "构建参数之后,创建订单之前"),

    WAIT_PAY(10, "待支付"),
    PAID(15, "已支付"),
    WAIT_REVIEW(20, "待审核"),
    WAIT_SHIPMENT(30, "待发货"),
    WAIT_TAKE_DELIVERY(40, "待收货"),
    ORDER_COMPLETION(50, "交易完成"),

    ORDER_ERROR(89, "异常状态"),

    ORDER_SUCCESS(90, "交易成功"),
    ORDER_CLOSE(91, "交易关闭"),
    ;

    private Integer status;

    private String desc;

    OrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, OrderStatusEnum> map = new HashMap<Integer, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getStatus(), statusEnum);
        }
    }};

    private static Map<String, OrderStatusEnum> descMap = new HashMap<String, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getDesc(), statusEnum);
        }
    }};

    public static OrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static OrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }


    public static String getDesc(int status) {
        for (OrderStatusEnum item : OrderStatusEnum.values()) {
            if (item.status == status) {
                return item.getDesc();
            }
        }
        return "";
    }
}