package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 第三方子订单号 这个字段只有老MNG才会用到
     */
    private String thirdSubOrderCode;

    /**
     * appId 销售方应用id不能为空
     */
    private Long appId;

    /**
     * 商品所有者用户id 租户id
     */
    private Long ownId;

    /**
     * 商品所有者用户类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer ownType;

    /**
     * 商品类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    private Integer goodsType;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 预占场景泛id，如活动id<br>
     * 如果是预占消耗库存，必填
     */
    private Long generalId;

    /**
     * 预占场景泛类型，{@link cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum}<br>
     * 如果是预占消耗库存，必填
     */
    private Integer generalType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;

    /**
     * 支付相关
     */
    private List<PaymentParam> paymentParams;

}