package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 订单查询参数
 * @Author dangcang
 * @Date 2021/11/10 3:05 下午
 **/
@Getter
@Setter
public class OrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 8035926659649749486L;

    /**
     * 使用游标查询 非导出请勿使用
     */
    private boolean useScroll = false;

    /**
     * 是否为兑吧查询
     */
    private Boolean fromDuibaQuery = false;

    /**
     * 提供下次查询时的scrollId scroll查询时返回此字段,
     */
    private String scrollId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 购买方AppId
     */
    private Long buyerAppId;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 卖家类型
     */
    private Integer sellerType;

    /**
     * 销售方appId
     */
    private Long sellerAppId;

    /**
     * 下单开始时间 毫秒级时间戳
     */
    private Date orderStartTime;

    /**
     * 下单截止时间 毫秒级时间戳
     */
    private Date orderEndTime;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 订单来源类型 字面量
     */
    private String orderSourceType;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 第三方订单号
     */
    private List<String> outerOrderCode;

    /**
     * 商品编码
     */
    private List<String> spuCode;

    /**
     * 规格编码
     */
    private List<String> skuCode;

    /**
     * 收件人名称
     */
    private String receiverName;

    /**
     * 收货人手机号
     */
    private String receiverPhone;

    /**
     * 充值账号
     */
    private String rechargeAccount;

    /**
     * 物流单号
     */
    private List<String> logisticsNo;

    /**
     * 供应商名称
     */
    private List<String> supplierName;

    /**
     * 供应商编码
     */
    private List<String> supplierCode;

    /**
     * 来源终端环境
     */
    private String environment;

    /**
     * 是否有发货提醒
     */
    private Boolean hasDeliveryRemind;
}