package cn.com.duiba.cloud.order.center.api.model.param.order;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/2 4:02 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class UserOrderQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = 283971009617380951L;
    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    private Integer buyerType;

    /**
     * 购买方AppId
     */
    private Long buyerAppId;

    /**
     * 订单状态
     */
    private Integer orderStatus;
}