package cn.com.duiba.cloud.order.center.api.model.param.virtual;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/3 4:21 下午
 **/
@Data
public class VirtualGoodsDeliveryParam implements Serializable {

    private static final long serialVersionUID = -5020815203953006911L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单序号
     */
    private Long orderSort;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    private Integer couponType;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 密码
     */
    private String couponPassword;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期截止时间
     */
    private Date endTime;

    /**
     * 备注
     */
    private String remark;
}