package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

/**
 * @Description 订单扩展信息类型说明枚举类
 * @Author dangcang
 * @Date 2021/11/14 11:00 上午
 **/
@Getter
public enum OrderExtraBizTypeEnum {

    ORDER_ENVIRONMENT(0, "订单下单终端环境:主订单维度"),
    TENANT_REMARK(1,"租户订单备注:主订单维度"),
    REMIND(2,"订单提醒:主订单维度"),
    THIRD_ORDER_CODE(3, "第三方订单号:主子都有"),
    LIFE_CYCLE(4, "生命周期:主子都有"),
    TENANT_CANCEL_REASON(5, "租户取消订单原因:主订单维度"),
    PURCHASE_AFTER_SALE_NUMBER(6, "销售订单售后单号关联的采购订单售后单号:双向记录:子订单维度"),
    GOODS_SELLER_APP_ID(7, "商品货主appId:子订单维度"),
    OLD_MNG_SUB_ORDER_CODE(8, "老MNG定制需求:双方子订单号需要关联上:子订单维度"),
    THIRD_ORDER_ERROR_MESSAGE(9,"第三方下单失败原因:主子都有"),
    PURCHASE_SALE_ORDER_SORT(10, "销售订单关联的采购订单子单号:双向记录:子订单维度"),
    ORDER_SOURCE_TYPE(11, "订单来源类型:现在只有活动需要:表明活动类型:主订单维度"),
    DELIVERY_NAME(12,"发货人名称:子订单维度:目前只存了卡券发货人"),
    ORDER_SELLER_APP_ID(13, "订单销售方appId:主订单维度"),
    RECHARGE_ACCOUNT(14, "充值账号:主订单维度"),
    ACTIVITY_JOIN_ID(15, "活动参与记录id:主订单维度"),
    DEVELOPER_USER_ID(16, "开发者用户Id:主订单维度"),
    RECHARGE_THIRD_ORDER_CODE(17, "充值子订单对应的第三方充值订单号:子订单维度"),
    COUPON_TYPE(18, "卡券类型:子订单维度"),
    COUPON_CODE(19, "券码:子订单维度"),
    COUPON_PASSWORD(20,"卡密:子订单维度:二次加密:EncryptUtil.encrypt()"),
    COUPON_START_TIME(21,"卡券有效期开始时间:子订单维度"),
    COUPON_END_TIME(22,"卡券有效期截止时间:子订单维度"),
    COUPON_REMARK(23,"卡券发货备注:子订单维度"),
    ;


    private Integer type;

    private String desc;

    OrderExtraBizTypeEnum(Integer type, String desc) {
        this.desc = desc;
        this.type = type;
    }
}