package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/4/6 7:28 下午
 **/
@Data
public class ExceptionHandleParam implements Serializable {

    private static final long serialVersionUID = 3556594273743295042L;
    /**
     * 主订单号
     */
    @NotBlank(message = "主订单号不能为空")
    private String orderCode;

    /**
     * 处理结果 成功= true 失败的false
     */
    @NotNull(message = "处理结果不能为空")
    private Boolean success;

    /**
     * 拒绝原因
     */
    private String reason;

    /**
     * 操作人id
     */
    @NotNull(message = "操作人不能为空")
    private Long operatorId;
}