package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 订单用户信息
 * @Author dangcang
 * @Date 2021/11/10 2:16 下午
 **/
@Data
public class UserParam implements Serializable {

    private static final long serialVersionUID = 3928768643187629699L;

    /**
     * 买家id
     */
    @NotNull(message = "买家id不能为空")
    private Long buyerId;

    /**
     * 都要传 没加注释是为了维护老数据
     */
    private String thirdUserId;

    /**
     * 买家类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    @NotNull(message = "买家类型不能为空")
    private Integer buyerType;

    /**
     * 购买方来源
     */
    @NotNull(message = "买方下单appId不能为空")
    private Long buyerAppId;

    /**
     * 卖家id 即租户id
     */
    @NotNull(message = "卖家id不能为空")
    private Long sellerId;

    /**
     * 卖家类型
     *  @see cn.com.duiba.cloud.manage.service.api.model.enums.AccountTypeEnum
     */
    @NotNull(message = "卖家类型不能为空")
    private Integer sellerType;
}