package cn.com.duiba.cloud.order.center.api.openapi.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/19 5:25 下午
 **/
@Data
public class OpenOrderSuccessParam implements Serializable {

    private static final long serialVersionUID = -9129723806055997149L;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 子订单序号
     */
    @NotEmpty(message = "子订单序号不能为空")
    private List<Long> orderSortList;

    /**
     * 应用上下文参数
     */
    @NotNull(message = "应用上下文参数不能为空")
    private ApiContext apiContext;
}