package cn.com.duiba.cloud.order.center.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 特殊订单来源枚举类
 * @Author dangcang
 * @Date 2022/7/13 5:49 下午
 **/
@Getter
public enum OrderSpeciallySourceTypeEnum {

    PROJECT_X(1, "星速台"),
    SEC_KILL(2, "秒杀"),
    ;

    private Integer type;

    private String desc;

    OrderSpeciallySourceTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static Map<Integer, OrderSpeciallySourceTypeEnum> map = new HashMap<Integer, OrderSpeciallySourceTypeEnum>() {{
        for (OrderSpeciallySourceTypeEnum speciallySourceTypeEnum : OrderSpeciallySourceTypeEnum.values()) {
            put(speciallySourceTypeEnum.getType(), speciallySourceTypeEnum);
        }
    }};

    public static OrderSpeciallySourceTypeEnum getByType(Integer type) {
        return map.get(type);
    }
}