package cn.com.duiba.cloud.order.center.api.enums;

import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;
import java.util.Objects;

/**
 * @Description toC销售订单状态adapter
 * @Author dangcang
 * @Date 2022/1/7 5:51 下午
 **/
@Getter
public enum SaleOrderAdapterStatusEnum {

    WAIT_PAY(1, "待支付", Lists.newArrayList(OrderStatusEnum.WAIT_PAY.getStatus())),
    WAIT_REVIEW(2, "待审核", Lists.newArrayList(OrderStatusEnum.WAIT_REVIEW.getStatus())),
    WAIT_SHIPMENT(3, "待发货", Lists.newArrayList(OrderStatusEnum.WAIT_SHIPMENT.getStatus(), OrderStatusEnum.ORDER_ERROR.getStatus(), OrderStatusEnum.PAID.getStatus())),
    WAIT_TAKE_DELIVERY(4, "待收货", Lists.newArrayList(OrderStatusEnum.WAIT_TAKE_DELIVERY.getStatus())),
    ORDER_SUCCESS(5, "交易成功", Lists.newArrayList(OrderStatusEnum.ORDER_COMPLETION.getStatus(), OrderStatusEnum.ORDER_SUCCESS.getStatus())),
    ORDER_CLOSE(6, "交易关闭", Lists.newArrayList(OrderStatusEnum.ORDER_CLOSE.getStatus())),
    ;

    private Integer status;

    private String desc;

    private List<Integer> adapterStatus;

    SaleOrderAdapterStatusEnum(Integer status, String desc, List<Integer> adapterStatus) {
        this.status = status;
        this.desc = desc;
        this.adapterStatus = adapterStatus;
    }

    public static SaleOrderAdapterStatusEnum getSaleOrderAdapterStatusEnum(OrderStatusEnum orderStatusEnum) {
        for (SaleOrderAdapterStatusEnum value : SaleOrderAdapterStatusEnum.values()) {
            if (value.getAdapterStatus().contains(orderStatusEnum.getStatus())) {
                return value;
            }
        }
        return null;
    }

    public static List<Integer> getOrderStatus(Integer saleOrderAdapterStatus) {
        for (SaleOrderAdapterStatusEnum value : SaleOrderAdapterStatusEnum.values()) {
            if (Objects.equals(value.getStatus(), saleOrderAdapterStatus)) {
                return value.getAdapterStatus();
            }
        }
        return null;
    }
}