package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/12/20 1:46 下午
 **/
@Data
public class SimpleOrderDTO implements Serializable {

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 销售方类型
     */
    private Integer sellerType;

    /**
     * 销售方id
     */
    private Long sellerId;

    /**
     * 购买方类型
     */
    private Integer buyerType;

    /**
     * 购买方id
     */
    private Long buyerId;

    /**
     * appId 下单方appId
     * 历史遗留问题 无法改名了
     * buyerAppId
     */
    private Long appId;

    /**
     * 根据order_type 可以知道具体来源
     */
    private String bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 买家备注
     */
    private String remark;

    /**
     * 订单商品名称
     */
    private String orderName;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 修改时间
     */
    private Long gmtModified;
}